from Tkinter import *
import time

class MyClock(Toplevel):
    def __init__(self, parent=None):
        # do superclass init
        Toplevel.__init__(self, parent)
        # make the window cover half the screen
        w, h = self.winfo_screenwidth()/2, self.winfo_screenheight()/2
        self.overrideredirect(1)
        self.geometry('%dx%d+0+0' % (w, h))
        # initialize instance attributes
        self.curtime = ''
        self.clock = Label()
        self.clock.pack()
        
def tick():
    newtime = time.strftime('%H:%M:%S')
    if newtime != clk.curtime:
        clk.curtime = newtime
    clk.clock.config(text=clk.curtime)
    clk.after(200, tick())
        
root = Tk()
clk = MyClock(root)
tick()
clk.mainloop( )
