import sys, os
from Tkinter import *
import tkMessageBox


class DemographicWindow(Toplevel):
    def __init__(self, parent=None, expt='none', subjNum=0):
        # do superclass init
        Toplevel.__init__(self, parent)
        # set the configuration
        self.title('Demographics')
        self.protocol('WM_DELETE_WINDOW', lambda:0)
        # initialize instance attributes
        self.expt = expt
        self.subjNum = subjNum
        self.age = StringVar()
        self.sex = StringVar()
        self.hispanic = StringVar()
        self.asian = IntVar()
        self.black = IntVar()
        self.middleeastern = IntVar()
        self.nativeamerican = IntVar()
        self.pacificislander = IntVar()
        self.northafrican = IntVar()
        self.white = IntVar()
        # set up the interface widgets
        self.makeform()
        # Grab the focus and set
        self.focus_set()
        self.grab_set()
        self.lift()
        
    def makeform(self):
        # Age field
        row1 = Frame(self)
        Label(row1, text='Age:').pack(side=LEFT)
        age = Entry(row1, width=5, textvariable=self.age)
        age.pack(side=LEFT)
        row1.pack(side=TOP, anchor=NW, fill=X, pady=15)
        # Sex field
        row2 = Frame(self)
        Label(row2, text='Sex:').pack(side=LEFT)
        Radiobutton(row2, text='Female', variable=self.sex,
            value='F').pack(side=LEFT)
        Radiobutton(row2, text='Male', variable=self.sex,
            value='M').pack(side=LEFT, fill=X)
        row2.pack(side=TOP, anchor=NW, fill=X, pady=15)
        # Ethnic origin field
        row3 = Frame(self, width=350)
        t = "Are you Hispanic/Latino?\n"
        t = t + "(Having origins in Cuban, Mexican, Puerto Rican, South or "
        t = t + "Central American, or other Spanish culture, regardless of "
        t = t + "race.)"
        Message(row3, text=t, width=350).pack(side=TOP, anchor=W)
        Radiobutton(row3, text='Yes', variable=self.hispanic,
            value='Y').pack(side=LEFT)
        Radiobutton(row3, text='No', variable=self.hispanic,
            value='N').pack(side=LEFT, fill=X)
        row3.pack(side=TOP, anchor=NW, fill=X, pady=15)
        # Racial field
        row4 = Frame(self)
        t = "Racial Origin\n  (Please check all that apply)"
        Message(row4, text=t, width=350).pack(side=TOP, anchor=W)
        races = {'Asian': self.asian,
                 'Black or African-American': self.black,
                 'Middle Eastern': self.middleeastern,
                 'Native American, American Indian, or Alaska native': \
                    self.nativeamerican,
                 'Native Hawaiian or other Pacific Islander': \
                    self.pacificislander,
                 'North African': self.northafrican,
                 'White': self.white}
        for (r, v) in races.items():
            row = Frame(row4)
            Checkbutton(row, text=r, variable=v,
                justify=LEFT).pack(side=LEFT)
            row.pack(side=TOP, anchor=W)
        row4.pack(side=TOP, anchor=W, fill=X, pady=15)
        # OK button
        self.ok = Button(self, text='OK', padx=30, pady=15, 
            command=self.submitform)
        self.ok.pack(side=RIGHT, padx = 15)
        #Set the focus on the AGE entry field
        age.focus_force()
        
    def submitform(self):
        # Make sure Age field is valid
        if not self.age.get():
            # if blank, then show message and continue
            t = "Please fill in your age. All other fields are optional."
            tkMessageBox.showinfo('Need age', t)
            return
        try:
            age = int(self.age.get())
        except ValueError:
            t = "Please use a number for your age."
            tkMessageBox.showinfo('Need age as number', t)
            return
        # get form data
        sex = self.sex.get()
        hispanic = self.hispanic.get()
        asian = self.asian.get()
        black = self.black.get()
        nativeamerican = self.nativeamerican.get()
        pacificislander = self.pacificislander.get()
        middleeastern = self.middleeastern.get()
        northafrican = self.northafrican.get()
        white = self.white.get()
        # check age
        if age < 18:
            # if less than 18, display message and quit
            t = "You must be at least 18 years of age to participate in "
            t = t + "this experiment."
            tkMessageBox.showinfo('Under 18', t)
        elif age > 60:
            # if more than 60, display message and quit
            t = "You must be no more than 60 years of age to participate in "
            t = t + "this experiment."
            tkMessageBox.showinfo('Over 60', t)
        else:
            filename = '%s%sdata%s%s.demographics.txt' % \
                (os.curdir, os.sep, os.sep, self.expt)
            # if the file does not exist, create a header
            if not os.path.exists(filename):
                f = open(filename, 'w')
                s = ['PID', 'Age', 'Sex', 'Hispanic', 'Asian', 'Black',
                     'Ntv_Amer', 'Pac_Isld', 'Mid_East','N_African',
                     'White']
                f.write('\t'.join(s)+'\n')
                f.close()
            # write data to file
            f = open(filename, 'a')
            s = '%d\t%d\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\n' % \
                (self.subjNum, age, sex, hispanic,
                 asian, black, nativeamerican, pacificislander,
                 middleeastern, northafrican, white)
            f.write(s)
            f.close()
        # close window
        self.destroy()
        
        
if __name__ == '__main__':
    root = Tk()
    root.title('Demographics Window launcher')
    dmg = DemographicWindow(root, 'TEST', 999)
    def submitdemographics(event):
        dmg.submitform()
        dmg.quit()
    dmg.ok.bind('<Return>', submitdemographics)
    dmg.ok.bind('<Button-1>', submitdemographics)
    dmg.mainloop()
    root.quit