# Read a table of squares and square roots and print the results

delimiter = '\t'
filename = 'squares.txt'

num, sqr, sqr_rt = [], [], []

# Read in values from file
fin = open(filename, 'r')
hdr = fin.readline().strip()
for row in fin:
    line = row.strip()
    entries = line.split(delimiter)
    num.append(int(entries[0]))
    sqr.append(int(entries[1]))
    sqr_rt.append(float(entries[2]))
fin.close()   

# Print a table of values
print hdr
for row in zip(num, sqr, sqr_rt):
    line = '%d%s%d%s%2.4f' % \
          (row[0], delimiter, row[1], delimiter, row[2])
    print line


