import os, sys
from Tkinter import *
import tkMessageBox

class StartWindow(Toplevel):
    def __init__(self, parent=None, expt='none', sessions=1):
        # do superclass init
        Toplevel.__init__(self, parent)
        # set the configuration
        self.title(expt)
        ##self.protocol('WM_DELETE_WINDOW', lambda:0)
        # initialize instance attributes
        self.expt = expt
        self.subjNum = StringVar()
        self.pid = 0
        self.nSessions = sessions
        self.sesVar = StringVar()
        self.curSession = 1
        self.locVar = StringVar()
        self.location = 'none'
        # set up the interface widgets
        self.makeform()
        # Make modal
        self.focus_set()
        self.grab_set()
        self.wait_window()

    def makeform(self):
        # Experiment title
        Label(self, text=self.expt, 
            font=('times', 28, 'bold')).pack(side=TOP)
        # Subject number field
        row1 = Frame(self)
        Label(row1, text='Participant ID:', width=15,
            justify=LEFT).pack(side=LEFT)
        pidE = Entry(row1, width=5, textvariable=self.subjNum)
        pidE.pack(side=LEFT)
        row1.pack(side=TOP, anchor=NW, fill=X, pady=15)
        # Session field
        if self.nSessions > 1:
            row2 = Frame(self)
            Label(row2, text='Session:', width=15,
                justify=LEFT).pack(side=LEFT)
            Entry(row2, width=5, textvariable=self.sesVar).pack(side=LEFT)
            row2.pack(side=TOP, anchor=NW, fill=X, pady=15)
        # Location field
        row3 = Frame(self)
        Label(row3, text='Location:', width=15,
            justify=LEFT).pack(side=LEFT)
        Entry(row3, width=5, textvariable=self.locVar).pack(side=LEFT)
        row3.pack(side=TOP, anchor=NW, fill=X, pady=15)
        # OK button
        Button(self, text='OK', padx=30, pady=15, 
            command=self.submitform).pack(side=RIGHT)
        #Set the focus on the subject number entry field
        pidE.focus_force()
        
    def submitform(self):
        # Make sure subject number field is valid
        if not self.subjNum.get():
            # if blank, then show message and continue
            t = "A Participant ID is need to continue"
            tkMessageBox.showinfo('Need PID', t)
            return
        try:
            # Get the input PID
            self.pid = int(self.subjNum.get())
            if self.pid < 0 or self.pid > 999: raise ValueError
        except ValueError:
            # Show error message and continue
            t = "Please enter a valid Participant ID between 1 and 999."
            tkMessageBox.showinfo('Invalid PID', t)
            return
        # Make sure session info is valid
        if self.nSessions > 1:
            if not self.sesVar.get():
                # if blank, then show message and continue
                t = "A session number is need to continue"
                tkMessageBox.showinfo('Need session number', t)
                return
            try:
                # Get the input current session number
                self.curSession = int(self.sesVar.get())
                if self.curSession < 1 or self.curSession > self.nSessions:
                    raise ValueError
            except ValueError:
                # Show error message and continue
                t = "Please enter a valid session number between 1 and %d" \
                    % (self.nSessions)
                tkMessageBox.showinfo('Invalid session number', t)
                return
        # Get location info
        self.location = self.locVar.get()
        # close window
        self.destroy()
        
if __name__ == '__main__':
    root = Tk()
    root.title('Start Window launcher')
    win = StartWindow(root, 'test', 3)
    print win.pid, win.curSession, win.location
    root.quit
