# Create a table of squares and square roots
import math

start, stop, step = 1, 100, 1
delimiter = '\t'
filename = 'squares.txt'

num, sqr, sqr_rt = [], [], []

for val in range(start, stop+1, step):
    num.append(val)
    sqr.append(val**2)
    sqr_rt.append(math.sqrt(val))

# Save to a delimited text file
fout = open(filename, 'w')
hdr = 'Num%sSquare%sSqrRoot\n' % (delimiter, delimiter)
print hdr
fout.write(hdr)
for row in zip(num, sqr, sqr_rt):
    line = '%d%s%d%s%2.4f\n' % \
          (row[0], delimiter, row[1], delimiter, row[2])
    print line
    fout.write(line)
fout.close()


