import os, sys, time, numpy
from Tkinter import *
import tkMessageBox

class DisplayWindow(Toplevel):
    def __init__(self, parent=None, expt='', stim='', resp='', ndist=0):
        # do superclass init
        Toplevel.__init__(self, parent)
        # make the window cover the full screen
        w, h = self.winfo_screenwidth(), self.winfo_screenheight()
        self.overrideredirect(1)
        self.geometry('%dx%d+0+0' % (w, h))
        # initialize instance attributes
        self.expt = expt
        self.stimulus = stim
        self.stimVar = StringVar()
        self.stimVar.set(self.stimulus)
        self.response = resp
        self.respVar = StringVar()
        self.respVar.set(self.response)
        self.distractors = dist
        self.nChoices = 1 + ndist
        self.trialTime = []
        self.trialStart = 0
        self.crResp = ''
        self.crRespVar = StringVar()
        self.rt_on = 0
        self.rt_off = 0
        self.done = IntVar()
        self.done.set(0)
        # set up the interface widgets
        # Empty label for top 100 pixels
        Label(self, text='', pady=50).pack(side=TOP)
        # Stimulus
        self.stimLabel = Label(self, text=self.stimulus, pady=20,
            justify=LEFT, font=('times', 28, 'bold'), 
            wraplenth='.75')
        self.stimLabel.pack(side=TOP, anchor=W, padx=10)
        # Response
        self.respLabel = Label(self, text=self.response, pady=20,
            justify=LEFT, font=('times', 28, 'bold'))
        self.respLabel.pack(side=TOP, anchor=W, padx=10)
        # Subject response input for text entry (constructed response)
        self.crResp = Entry(self, width=50, textvariable=self.crRespVar,
            font=('times', 28, 'bold'))
        self.crResp.pack(side=TOP, anchor=NW, pady=5, padx=10)
        # Radio buttons for multiple choice
        if self.nChoices > 1:
            self.choices = []
            choices = [resp] + dist
            self.mcRespVar = StringVar()
            for n in range(self.nChoices):
                if n < len(choices):
                    t = choices[n]
                else:
                    t = ''
                self.choices.append(Radiobuttion(self, \
                    text=t, variable=self.mcRespVar, value=t))
                self.choices[n].pack(side=TOP, anchor=NW, pady=5, padx=10)
        ### OK button
        ##self.ok = Button(self, text='OK', padx=30, pady=15,
        ##        command=self.submitform)
        ##self.ok.pack(side=TOP)


    def hideMC(self):
        for button in self.choices:
            button.config(state='disabled')
    
    def showMC(self, dist=[], randomize=True):
        nDist = len(dist)
        # If a new set of distractors are specified
        if nDist > 0:
            # Verify that the number of distractors is within the capacity
            # of the radio button array
            if nDist > len(self.choices) -1:
                errMsg = "Fatal error in stimdisplay.showMC ...\n"
                errMsg += "Too many distractors input"
                tkMessageBox.showerror('ERROR', errMsg)
                root.quit()
                sys.exit(errMsg)
            # Assemble the set of choices
            choices = [self.response] + dist
            if randomize: numpy.random.shuffle(choices)
            # Hide all the buttons
            self.hideMC
            # Assign the choices to the buttons and enable the buttons
            for n in range(nDist):
                self.choices[n].config(\
                    text=choice[n], value=choice[n], state=NORMAL)
        # otherwise, leave the values as they are and enable the buttons
        else:
            for button in self.choices:
                button.config(state=NORMAL)
        
##    def submitform(self):
##        # Get the current time and calculate reaction time
##        stopTime = time.time()
##        self.rt_off = int((stopTime-self.trialStart)*1000)
##        # Get subject response
##        self.subjResp = self.subjRespVar.get()
##        print 'Form submitted'
##        # release control back to the parent script
##        self.done.set(1)
##        
##    def updateform(self, stim=[], resp=[], dist=[]):
##        # Set the stimulus label
##        if stim: self.stimulus = stim
##        self.stimLabel.config(text = self.stimulus)
##        # Set the response label
##        if resp: self.response = resp
##        self.respLabel.config(text = self.response)
##        # Erase the subjResp field
##        self.subjRespVar.set('')
##        #Set the focus on the subject response entry field
##        self.focus_set()
##        self.resp.focus_force()
##        self.done.set(0)
##        # Redraw the window
##        self.update_idletasks()
##        # Get the current time
##        self.trialStart = time.time()
##        
##        
##if __name__ == '__main__':
##    root = Tk()
##    root.title('Display Window launcher')
##    # make the root window cover the full screen
##    ##w, h = root.winfo_screenwidth(), root.winfo_screenheight()
##    ##root.geometry('%dx%d+0+0' % (w, h))
##    # Hide the root window
##    root.withdraw()
##    win = DisplayWindow(root, 'test')
##    sr = [ ['This is stimulus item 1', 'Response 1'],
##           ['This is stimulus item 2', 'Response 2'],
##           ['This is stimulus item 3', 'Response 3']]
##    for s in sr:
##        win.updateform(s[0],s[1])
##        print 'Updated form'
##        win.after(12000, win.submitform())
##        print 'Set timer...waiting...'
##        #win.mainloop()
##        win.wait_variable(win.done)
##        print win.stimulus
##        print win.response
##        print win.subjResp
##    root.quit
