class Stimulus(object):
    def __init__(self, sid=0, stim='', corrResp='', dist=[]):
        # Initialize instance attributes
        #   Seq, CondCode, CondName, PresNum, PresType, StimID, Stim, Resp
        # Trial data
        self.session = 0         # Session number
        self.seq = 0             # Sequence within a session
        self.condCode = 0        # Condition code
        self.condName= ''        # Condition name
        self.presNum = 0         # Presentation for this stimulus
        self.presType = ''       # 'S', 'T', 'F', 'MC', 'CR'
        self.presTime = 12000    # in msec. Set to [] for self-paced trials.
        self.stimID = sid        # stimulus ID number
        self.stim = stim         # stimulus item
        self.corrResp = corrResp # correct response
        self.distractors = dist  # list of distractors
        # Performance data
        self.rt_on = 0           # onset reaction time (from trial start)
        self.rt_off = 0          # offset reaction time (from trial start)
        self.subjResp = ''       # subject response
        self.score = -1          # score (0=Incorrect resp, 1=Correct resp)
        
    def __str__(self, hdr=''):
        s = []
        if hdr == 'header':
            # create header
            s.append('Session')
            s.append('Seq')
            s.append('CondCode')
            s.append('CondName')
            s.append('PresNum')
            s.append('PresType')
            s.append('PresTime')
            s.append('StimID')
            s.append('Stim')
            s.append('corrResp')
            s.append('rt_on')
            s.append('rt_off')
            s.append('subjResp')
            s.append('score')
            s.append('distractors')
        else:
            # get data this trial as a tab-delimited string
            s.append('%d' % self.session)
            s.append('%03d' % self.seq)
            s.append('%02d' % self.condCode)
            s.append(self.condName)
            s.append('%03d' % self.presNum)
            s.append(self.presType)
            s.append('%05d' % self.presTime)
            s.append('%03d' % self.stimID)
            s.append(self.stim)
            s.append(self.corrResp)
            s.append('%05d' % self.rt_on)
            s.append('%05d' % self.rt_off)
            s.append(self.subjResp)
            s.append('%d' % self.score)
            for d in self.distractors: s.append(d)
        # assemble as a tab-delimited string and return
        return '\t'.join(s) + '\n'
        
    def scoreTrial(self):
        # compare subj response to correct response. Ignoring case, leading
        # whitespace, and trailing whitespace.
        sr = self.subjResp.lower().strip()
        cr = self.corrResp.lower().strip()
        if sr == cr:
            self.score = 1
        else:
            self.score = 0
