import os, sys

def read_file(filename, delimiter='\t'):
    """
    Read the contents of a delimited data file. Return the data as a list
    of tuples.
    """
    # Set up the data structure
    data = []
    # Read the file
    try:
        # Open the file in read mode
        fin = open(filename, 'rU')
        # Read data one line at a time
        while True:
            line = fin.readline().strip()
            # Exit loop when EOF or a blank line is found
            if line == '': break
            # Ignore lines commented with a pound sign
            if line[0] == '#': continue
            # Parse the data
            parsed = line.split(delimiter)
            # Add to the data structure
            data.append(tuple(parsed))
        # Close the file
        fin.close()
        # Return the data
        return data
    except IOError:
        if os.path.exists(stimfile):
            errMsg = "Error reading data file '%s'\n" % (filename)
        else:
            errMsg = "Data file '%s' not found\n" % (filename)
        sys.exit(errMsg)

def calc_col_means(data):
    """
    Given a rectangular 2-D data structure, calculate the arithmetic mean
    of each column and return as a tuple.
    """
    means = []
    n_rows = len(data)
    n_cols = len(data[0])
    for col in range(n_cols):
        col_sum = 0.0
        for row in data:
            col_sum += row[col]
        col_mean = col_sum / n_rows
        means.append(col_mean)
    return tuple(means)

def calc_col_stddevs(data):
    """
    Given a rectangular 2-D data structure, calculate the standard deviation
    for each column and return as a tuple.
    """
    pass

def calc_col_stderrs(data):
    """
    Given a rectangular 2-D data structure, calculate the standard error of
    the mean for each column and return as a tuple.
    """
    pass

def calc_regr(data):
    """
    Given a rectangular 2-D data structure, calculate the pair-wise regression
    coefficients between each pair of columns and return as a 2-D structure:
                col_1    col_2    col_3    ...  col_n
        col_1    r_11     r_12     r_13          r_1n
        col_2    r_21     r_22     r_23          r_2n
        col_3    r_31     r_32     r_33          r_3n
        ...      
        col_n    r_n1     r_n2     r_n3          r_nn
    """
    pass

# Main program routine
if __name__ == '__main__':
    
    # Set default data filename
    filename = 'data.txt'
    # Read data from file
    data = read_file(filename)

    # Calculate column means
    means = calc_col_means(data)
    output = 'Means:\t'
    for col in means:
        output += '%2.4f\t' % col
    print output

    # Calculate column standard deviations
    stdev = calc_col_stddevs(data)
    output = 'StdDev:\t'
    for col in stdev:
        output += '%2.4f\t' % col
    print output

    # Calculate column standard errors
    stderr = calc_col_stderrs(data)
    output = 'StdErr:\t'
    for col in stderr:
        output += '%2.4f\t' % col
    print output

    # Calculate regressions
    regr = calc_regr(data)
    ## Insert routine to print out the regression matrix
    

            
        
    
        
