class Time(object):
    """
    Represents the time of day.

    Attributes:
        hour
        minute
        second
    """
    def __init__(self, h=0, m=0, s=0):
        self.hour = h
        self.minute = m
        self.second = s


def print_time(t):
    """
    Given a Time object, print the time in hour:minute:second format.
    """
    print '%02d:%02d:%02d' % (t.hour, t.minute, t.second)

def increment_time(t1, t2):
    """
    Given two Time objects t1 and t2, add t2 to t1
    """
    # Add the times
    t1.hour   += t2.hour
    t1.minute += t2.minute
    t1.second += t2.second

def add_time(t1, t2):
    """
    Given two Time objects, add the values and return a new Time object
    """
    # Add the times
    new_time = Time()
    new_time.hour = t1.hour + t2.hour
    new_time.minute = t1.minute + t2.minute
    new_time.second = t1.second + t2.second
    return new_time
