class Time(object):
    """
    Represents the time of day.

    Attributes:
        hour
        minute
        second
    """
    def __init__(self, h=0, m=0, s=0):
        self.hour = h
        self.minute = m
        self.second = s


def print_time(t):
    """
    Given a Time object, print the time in hour:minute:second format.
    """
    print '%02d:%02d:%02d' % (t.hour, t.minute, t.second)

def increment_time(t1, t2):
    """
    Given two Time objects t1 and t2, add t2 to t1
    """
    # Check the input arguments
    if type(t1) != Time or type(t2) != Time:
        raise AttributeError, 'invalid argument passed to increment_time'
    if not valid_time(t1) or not valid_time(t2):
        raise ValueError, 'invalid Time object in increment_time'
    # Add the times
    t1.hour   += t2.hour
    t1.minute += t2.minute
    t1.second += t2.second

def add_time(t1, t2):
    """
    Given two Time objects, add the values and return a new Time object
    """
    # Add the times
    new_time = Time()
    new_time.hour = t1.hour + t2.hour
    new_time.minute = t1.minute + t2.minute
    new_time.second = t1.second + t2.second
    return new_time

def valid_time(t):
    validity = True
    # All values must be at least zero
    if t.hour < 0 or t.minute < 0 or t.second < 0:
        validity = False
    # Minute and second must be base 60
    if t.minute >= 60 or t.second >= 60:
        validity = False
    return validity
    
