class Time(object):
    """
    Represents the time of day.

    Attributes:
        hour
        minute
        second
    """
    def __init__(self, h=0, m=0, s=0):
        self.hour = h
        self.minute = m
        self.second = s


    def print_time(self):
        """
        Print the time in hour:minute:second format.
        """
        print '%02d:%02d:%02d' % (self.hour, self.minute, self.second)


    def increment(self, t2):
        """
        Increment the time 
        """
        # Check the input arguments
        if type(t2) != Time:
            raise AttributeError, 'invalid argument passed to Time.increment()'
        if  not t2.valid_time():
            raise ValueError, 'invalid Time object passed to Time.increment()'
        # Add the times
        self.hour   += t2.hour
        self.minute += t2.minute
        self.second += t2.second


    def add_time(self, t2):
        """
        Given a Time object, add the values and return a new Time object
        """
        # Add the times
        new_time = Time()
        new_time.hour = self.hour + t2.hour
        new_time.minute = self.minute + t2.minute
        new_time.second = self.second + t2.second
        return new_time


    def valid_time(self):
        validity = True
        # All values must be at least zero
        if self.hour < 0 or self.minute < 0 or self.second < 0:
            validity = False
        # Minute and second must be base 60
        if self.minute >= 60 or self.second >= 60:
            validity = False
        return validity
    
