class Time(object):
    """
    Represents the time of day.

    Attributes:
        hour
        minute
        second
    """
    def __init__(self, h=0, m=0, s=0):
        self.set_time(h, m, s)

    def __str__(self):
        """
        Return the time as a string in hour:minute:second format.
        """
        return '%02d:%02d:%02d' % (self.hour, self.minute, self.second)

    def __add__(self, other):
        return self.add_time(other)

    def increment(self, t2):
        """
        Increment the time 
        """
        # Check the input arguments
        if type(t2) == Time:
            # Add the times
            self.hour   += t2.hour
            self.minute += t2.minute
            self.second += t2.second
        elif type(t2) == int:
            # Increment the seconds
            self.second += t2
        else:
            raise AttributeError, 'invalid argument passed to Time.increment()'
        self.adjust_base_60()

    def add_time(self, t2):
        """
        Given a Time object, add the values and return a new Time object
        """
        # Add the times
        new_time = Time()
        new_time.hour = self.hour + t2.hour
        new_time.minute = self.minute + t2.minute
        new_time.second = self.second + t2.second
        new_time.adjust_base_60()
        return new_time

    def set_time(self, hour=0, minute=0, second=0):
        self.hour = hour
        self.minute = minute
        self.second = second
        self.adjust_base_60()
        
    def adjust_base_60(self):
        """
        Adjust the minutes and seconds to make sure they are in base 60
        """
        # Increment minutes as necessary and adjust seconds
        self.minute += self.second // 60
        self.second = self.second % 60
        # Increment hours as necessary and adjust minutes
        self.hour += self.minute // 60
        self.minute = self.minute % 60
